#include "stdafx.h"

#include <stdio.h>
#include <MapArxApi.h>
#include <MapSession.h>
#include <MapProj.h>
#include <MapReactors.h>
#include <MapBoundary.h>
#include <MapQuery.h>
#include <MapAlteration.h>
#include <MapValue.h>
#include <MapTemplate.h>
#include <gemat3d.h>
//#include <adestrar.h>
#include <accmd.h>
#include <adscodes.h>
#include <rxregsvc.h>        

#include "MyMapReactors.h"


/////////////////////////////////////////////////////////////////////////////
//AcMyDrawingSetReactor
//
AcMyDrawingSetReactor::AcMyDrawingSetReactor() : AcMapDrawingSetReactor()
{}

AcMyDrawingSetReactor::~AcMyDrawingSetReactor()
{}

void        
AcMyDrawingSetReactor::DrawingAttached(const AcMapAttachedDrawing *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->DrawingAttached(pObj);
}
    
void        
AcMyDrawingSetReactor::DrawingDetached(unsigned long Id, const char *pcName, int level)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->DrawingDetached(Id, pcName, level);
}
    
void        
AcMyDrawingSetReactor::DrawingActivated(const AcMapAttachedDrawing *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->DrawingActivated(pObj);
}
    
void        
AcMyDrawingSetReactor::DrawingDeactivated(const AcMapAttachedDrawing *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->DrawingDeactivated(pObj);
}

void        
AcMyDrawingSetReactor::DrawingSettingsModified(const AcMapAttachedDrawing *pObj) 
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->DrawingSettingsModified(pObj);
}

/////////////////////////////////////////////////////////////////////////////
//AcMyQueryLibraryReactor
//
AcMyQueryLibraryReactor::AcMyQueryLibraryReactor() 
{}

AcMyQueryLibraryReactor::~AcMyQueryLibraryReactor() 
{}

void        
AcMyQueryLibraryReactor::QueryCategoryAdded(const AcMapQueryCategory *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->QueryCategoryAdded(pObj);
}

void        
AcMyQueryLibraryReactor::QueryCategoryDeleted(unsigned long Id, const char *pcName)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->QueryCategoryDeleted(Id, pcName);
}

void        
AcMyQueryLibraryReactor::QueryCategoryRenamed(const AcMapQueryCategory *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->QueryCategoryRenamed(pObj);
}

void        
AcMyQueryLibraryReactor::QueryAdded(const AcMapQueryAttribute *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->QueryAdded(pObj);
}

void        
AcMyQueryLibraryReactor::QueryDeleted(unsigned long QueryId,const char *pcName)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->QueryDeleted(QueryId, pcName);
}

void        
AcMyQueryLibraryReactor::QueryRenamed(const AcMapQueryAttribute *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->QueryRenamed(pObj);
}

void        
AcMyQueryLibraryReactor::QueryModified(const AcMapQueryAttribute *pObj)
{
	ASSERT(NULL != m_pDlg);
	if(NULL == m_pDlg)
		return;

	//forward the message to the dialog
	m_pDlg->QueryModified(pObj);
}

